-- 用户数据表
CREATE TABLE IF NOT EXISTS user_data(
    Item TEXT PRIMARY KEY,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    JsonContent JSON,
    TextContent TEXT
);

-- app数据表
CREATE TABLE IF NOT EXISTS app_data(
    AppId TEXT PRIMARY KEY,
    Content JSON
);

-- mdb数据表
CREATE TABLE IF NOT EXISTS mdb(
    Path TEXT PRIMARY KEY,
    Content JSON
);

-- 映射配置表
CREATE TABLE IF NOT EXISTS mapping_config(
    Id INTEGER PRIMARY KEY,
    Uri TEXT UNIQUE,
    IgnoreEtags JSON,
    Interfaces JSON,
    TextContent TEXT,
    ClassName TEXT,
    SchemaPath TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

-- 映射配置表自动生成更新时间
CREATE TRIGGER IF NOT EXISTS mapping_config_updatetime_trig
AFTER UPDATE OF IgnoreEtags, Interfaces, TextContent, ClassName, SchemaPath ON mapping_config
FOR EACH ROW
BEGIN
  UPDATE mapping_config SET UpdateTime = (strftime('%Y%m%d%H%M%S', 'now', 'localtime')) WHERE Id = NEW.Id;
END;

CREATE TABLE IF NOT EXISTS mapping_plugin_scripts(
    Id INTEGER PRIMARY KEY,
    UriId TEXT,
    Type TEXT,
    Path TEXT,
    Name TEXT,
    Content TEXT,
    Params JSON,
    FunctionBody TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

CREATE TRIGGER IF NOT EXISTS mapping_plugin_scripts_updatetime_trig
AFTER UPDATE OF UriId, Type, Path, Name, Content, Params, FunctionBody ON mapping_plugin_scripts
FOR EACH ROW
BEGIN
  UPDATE mapping_plugin_scripts SET UpdateTime = (strftime('%Y%m%d%H%M%S', 'now', 'localtime')) WHERE Id = NEW.Id;
END;

CREATE TABLE IF NOT EXISTS workspace_list_v1(
    Id INTEGER PRIMARY KEY,
    Name TEXT UNIQUE NOT NULL,
    IsCurrent BOOLEAN DEFAULT 0,
    IsDefault BOOLEAN DEFAULT 0,
    IsDeviceBranch BOOLEAN DEFAULT 0,
    OriginPath TEXT,
    PathType TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

CREATE TABLE IF NOT EXISTS workspace_remote_info(
    Name PRIMARY KEY,
    RemoteUrl TEXT,
    Branch TEXT,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

-- manifest管理表
CREATE TABLE IF NOT EXISTS manifest_data(
    Id INTEGER PRIMARY KEY autoincrement,
    SpaceName TEXT,
    RemoteUrl TEXT,
    MasterBranch TEXT,
    HashInit BOOLEAN,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);

CREATE TABLE IF NOT EXISTS manifest_async_status(
    Id INTEGER PRIMARY KEY autoincrement,
    SpaceName TEXT,
    IsAsync BOOLEAN DEFAULT 0,
    CreateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime')),
    UpdateTime TEXT DEFAULT (strftime('%Y%m%d%H%M%S', 'now', 'localtime'))
);