const components = require('./components.json');
const apis = require('./apis.json');

const componentList = components.map((item) => item.name || item);
const apiList = apis.map((item) => item.name || item);

function kebabCase(key) {
  const result = key.replace(/([A-Z])/g, ' $1').trim();
  return result.split(' ').join('-').toLowerCase();
}

module.exports = {
  OpenDesignResolver: function (resolver, resolverOptions = {}, opendesignPath) {
    const rlt = resolver(resolverOptions);
    const themeFolder = opendesignPath || '@computing/opendesign2/themes';
    return rlt.map((item) => {
      let newResolveFn;
      if (item.type === 'component') {
        newResolveFn = async function (name) {
          if (name.startsWith('O')) {
            const partialName = kebabCase(name);
            if (componentList.includes(partialName)) {
              let sytlePath;
              if (resolverOptions.importStyle === 'sass') {
                sytlePath = `${themeFolder}/es/${partialName}/index`;
              } else {
                sytlePath = `${themeFolder}/es/${partialName}/css`;
              }

              const r = {
                name: name,
                from: '@computing/opendesign2',
                sideEffects: sytlePath,
              };
              return r;
            } else if (apiList.includes(partialName)) {
              const r = {
                name,
                from: '@computing/opendesign2',
              };
              return r;
            }
          } else if (name.startsWith('El')) {
            const partialName = kebabCase(name.replace(/^El/, ''));
            let r = await item.resolve(name);
            if (componentList.includes(partialName)) {
              if (r) {
                let sytlePath;
                if (resolverOptions.importStyle === 'sass') {
                  sytlePath = `${themeFolder}/es/${partialName}/index`;
                } else {
                  sytlePath = `${themeFolder}/es/${partialName}/css`;
                }

                if (typeof r.sideEffects === 'string') {
                  r.sideEffects = [r.sideEffects, sytlePath];
                } else if (Array.isArray(r.sideEffects)) {
                  r.sideEffects.push(sytlePath);
                }
              }
            }

            return r;
          }
        };
      } else if (item.type === 'directive') {
        const directives = {
          Loading: { importName: 'ElLoadingDirective', styleName: 'loading' },
          Popover: { importName: 'ElPopoverDirective', styleName: 'popover' },
          InfiniteScroll: {
            importName: 'ElInfiniteScroll',
            styleName: 'infinite-scroll',
          },
        };

        newResolveFn = async function (name) {
          const directive = directives[name];
          const r = await item.resolve(name);

          if (directive && componentList.includes(directive.styleName)) {
            if (r) {
              let sytlePath;
              if (resolverOptions.importStyle === 'sass') {
                sytlePath = `${themeFolder}/es/${directive.styleName}/index`;
              } else {
                sytlePath = `${themeFolder}/es/${directive.styleName}/css`;
              }

              if (r && typeof r.sideEffects === 'string') {
                r.sideEffects = [r.sideEffects, sytlePath];
              } else if (Array.isArray(r.sideEffects)) {
                r.sideEffects.push(sytlePath);
              }
            }
          }
          return r;
        };
      }

      return {
        type: item.type,
        resolve: newResolveFn,
      };
    });
  },
};
