//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { IMainMenu } from '@/model/base-interface';
import { IStyleConfig } from '@/services/customize/styleConfig.datatype';
import { traduction } from './language';
import useStore from '@/stores';

/**
 * pinia store数据分为4大类 loct, event, glob, menu
 * 每个模块都有自己的actions
 */

// 获取store的数据
export function getStoreData(storeModule: string, key: string): any {
  return useStore().state[storeModule][key];
}

// 设置store的数据
export function setStoreData(storeModule: string, key: string, value: any) {
  let method = '';
  switch (storeModule) {
    case 'loct':
      method = 'setLoctState';
      break;
    case 'event':
      method = 'setEventState';
      break;
    case 'glob':
      method = 'setGlobState';
      break;
    case 'theme':
      method = 'setThemeState';
      break;
    default:
      method = 'setLoctState';
  }
  useStore().state[storeModule][method]({ type: key, value });
}

export function showSuccessMessage(successMsg?: string) {
  setStoreData('event', 'alertMessage', {
    type: 'success',
    message: successMsg || traduction('COMMON_SUCCESS'),
  });
}

export function showFailedMessage(errorMsg?: string) {
  setStoreData('event', 'alertMessage', {
    type: 'error',
    message: errorMsg || traduction('COMMON_FAILED'),
  });
}

export function findMainMenu(mainMenuId: string) {
  const mainMenu = getStoreData('menu', 'mainMenu');
  return mainMenu.filter((item: IMainMenu) => {
    return item.id === mainMenuId;
  })[0];
}

export function setMenuStoreData(mainId: string, subIds: string[], supported: boolean) {
  useStore().state.menu.setChildMenu({ mainId, subIds, supported });
}

export function setThemeStoreData(data: IStyleConfig) {
  useStore().state.theme.initThemeState(data);
}

export function loading(state: boolean) {
  setStoreData('glob', 'isLoading', state);
}

export function resetLoctData() {
  useStore().state.loct.resetLoctState();
}
