//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '../utils/http-service';
import { UI_REST_SERVICES_WEBSERVICE, UI_REST_SERVICE_WEBSERVICE_EXPORTCSR } from '../api/api';
import { reqPath } from '@/api/reqPath';

// 获取WEB服务基本配置
export function getWebService(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_SERVICES_WEBSERVICE)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch(error => {
        reject(error);
      });
  });
}

// 设置WEB服务基本配置
export function setWebService(params: any): Promise<any> {
  return $http.patch(UI_REST_SERVICES_WEBSERVICE, params);
}

// 生成并导出CSR文件
export function exportCSR(params: any): Promise<any> {
  return $http.post(UI_REST_SERVICE_WEBSERVICE_EXPORTCSR, params);
}

// 查询证书生成进度
export function task(url: string) {
  return $http.get(url);
}

// 查询SSL证书信息
export function getSSLCertificates(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.userAndSecurity.sslCertificates)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function getSSLGMCertificates(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.userAndSecurity.gmCertificates)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch(error => {
        reject(error);
      });
  });
}
