//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { reqPath } from '@/api/reqPath';
import $http from '../utils/http-service';
import { UI_REST_GENERALDOWNLOAD } from '@/api/api';

export function videoScreenCapture(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.maintance.video.systemDiagnostic)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch(error => {
        reject(error);
      });
  });
}

export function videoLogin(type: string) {
  const params = {
    VideoType: type,
  };
  return $http.post(reqPath.maintance.video.videoPlayLogin, params, { ignoredErrorTip: true });
}

export function videoLogout() {
  return $http.post(reqPath.maintance.video.stopVideo, {});
}

export function exportJavaVideoStartupFile(params: any) {
  const httpOptions = {
    responseType: 'blob',
  };
  return $http.post(reqPath.maintance.video.exportVideoStartupFile, params, httpOptions);
}

export function exportJavaVideoStartupFail(params: any) {
  return $http.post(reqPath.maintance.video.exportVideoStartupFile, params);
}

export function exportHtml5VideoStartupFile(params: any) {
  const httpOptions = {
    responseType: 'text',
  };
  return $http.post(reqPath.maintance.video.exportVideoStartupFile, params, httpOptions);
}

export function queryTask(url: string) {
  return $http.get(url);
}

export function stopVideo(params: any) {
  return $http.post(reqPath.maintance.video.stopVideo, params);
}

export function downloadVideoFile(params: any) {
  return $http.post(reqPath.maintance.video.downloadVideo, params);
}

// 录像功能使能 最后一屏使能
export function setOnOffVal(params: any) {
  return $http.patch(reqPath.maintance.video.systemDiagnostic, params);
}

// 手动截屏
export function capturescreenshot(params: any) {
  return $http.post(reqPath.maintance.video.captureScreenshot, params);
}

// 删除截屏
export function deletescreenshot(params: any) {
  return $http.delete(reqPath.maintance.video.deleteScreenshot, params);
}

// 下载
export function downloadData(fileName: string) {
  const data = {
    Path: `/tmp/web/${fileName}`,
    TransferProtocol: 'HTTPS',
  };
  return $http.post(UI_REST_GENERALDOWNLOAD, data, { responseType: 'blob' });
}