//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.

import useStore from '@/stores';

export default class UserInfoService {
  public $store: any;

  public reset(): void {
    this.$store.state.loct.resetLoctState();
  }

  public get(attr: any): any {
    if (attr) {
      return this.$store.state.loct[attr];
    }
    return undefined;
  }

  public set(type: any, value: any) {
    this[type] = value;
    this.$store.state.loct.setLoctState({ type, value });
  }

  // 查询是否具有指定的权限组合
  public hasPrivileges(roleArr: string[]) {
    const privileges = this.get('privil') || [];
    if (privileges.length === 0) {
      return false;
    }

    const tempArr = privileges.filter((role: string) => {
      return roleArr.indexOf(role) > -1;
    });

    return tempArr.length === roleArr.length;
  }

  getToken() {
    return this.get('to');
  }

  getManagersId() {
    return this.get('managersId');
  }

  public updateStorageUserInfo() {

  }

  constructor() {
    this.$store = useStore();
  }
}