//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { UI_REST_ACCESSMGNT_ADVANCEDSECURITY } from '@/api/api';
import $http from '../utils/http-service';

// 获取安全增强信息
export function getSecurityInfo(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_ACCESSMGNT_ADVANCEDSECURITY)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch(error => {
        reject(error);
      });
  });
}

// 设置安全增强信息
export function updateUser(params: any) {
  return $http.patch(UI_REST_ACCESSMGNT_ADVANCEDSECURITY, params);
}
