//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { UI_REST_BMCSETTING_NTP } from '@/api/api';
import $http from '../utils/http-service';

// 获取NTP信息
export function getNtpData(): Promise<any> {
  return getData(UI_REST_BMCSETTING_NTP);
}

export function getData(url: string): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(url)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch(error => {
        reject(error);
      });
  });
}

// 设置NTP配置
export function setNtpConfig(params: any): Promise<any> {
  return $http.patch(UI_REST_BMCSETTING_NTP, params);
}
