//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { IColorConfig } from '@/services/customize/styleConfig.datatype';
import { IStyleConfig } from './styleConfig.datatype';

const DEFAULT_STYLE_CONFIG: IStyleConfig = {
  brandElement: {},
  loginPage: {},
  colorConfig: {} as IColorConfig,
  layoutConfig: {},
  textStyleConfig: {},
  compStyleConfig: {},
};

export class StyleConfig {
  private styleConfig: IStyleConfig;

  constructor(data?: IStyleConfig) {
    this.styleConfig = Object.assign({}, DEFAULT_STYLE_CONFIG, data);
  }

  get getStyleConfig(): IStyleConfig {
    return this.styleConfig;
  }
}
