//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { ILdapController } from '@/model/Users/ldap-interface';

export interface IBrandElementConfig {}

export interface ILoginPageConfig {}

export interface IColorConfig {
  themeMode: string;
  brandColor: string;
  backgroundColor: string;
  alarmColor: IAlarmColor;
  stateColor: IStateColor;
}

export interface IAlarmColor {
  criticalColor: string;
  warningColor: string;
  minorColor: string;
}

export interface IStateColor {
  alertColor: string;
  switchColor: string;
}

export interface ILayoutConfig {}

export interface ITextStyleConfig {
  fontSize?: string;
}

export interface ICompStyleConfig {}

export interface IStyleConfig {
  brandElement: IBrandElementConfig;
  loginPage: ILoginPageConfig;
  colorConfig: IColorConfig;
  layoutConfig: ILayoutConfig;
  textStyleConfig: ITextStyleConfig;
  compStyleConfig: ICompStyleConfig;
}

export interface ILayout {
  nav: string;
  control: IControl;
}

export interface IControl {
  radius: string;
  shadow: string;
}

export interface IInfo {
  size: string;
  position: string;
}
