//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';
import { IResponseUserData, ICustError } from '../pages/User/models/type';
import { UI_REST_FIRMWAREINVENTORY } from '@/api/api';

export default class CaCertificateService {
  // 查询证书列表
  public static getCaCertificateList(): Promise<IResponseUserData[]> {
    return new Promise((resolve, reject) => {
      $http
        .get('/UI/Rest/AccessMgnt/CertMgnt/CertsInformation/0')
        .then((res: any) => {
          resolve(res.data);
        })
        .catch(error => {
          reject(error);
        });
    });
  }

  // 删除证书
  public static deletedCaCertificate(certificateType: string, id: string): Promise<ICustError> {
    return new Promise((resolve, reject) => {
      const url = '/UI/Rest/AccessMgnt/CertMgnt/DeleteCert';
      let params = { CertificateType: Number(certificateType), ID: Number(id) };
      $http
        .delete(url, params)
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }

  // 更新使能状态 和 保存
  public static certUpdateSaveData(params: any): any {
    return new Promise((resolve, reject) => {
      const url = '/UI/Rest/AccessMgnt/CertUpdateService';
      $http
        .patch(url, params)
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }
  
  // 更新证书
  public static updateCertFromCA(): any {
    return new Promise((resolve, reject) => {
      const url = '/UI/Rest/AccessMgnt/CertUpdateService/UpdateCertFromCA';
      $http
        .post(url, {})
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }

  public static getData(): any {
    return new Promise((resolve, reject) => {
      const url = '/UI/Rest/AccessMgnt/CertUpdateService';
      $http
        .get(url)
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }

  // 导入客户端证书
  public static imporCustomCertificate(fileName: string, password: string) {
    let data = { Content: `/tmp/web/${fileName}`, Password: password };
    return new Promise((resolve, reject) => {
      const url = '/UI/Rest/AccessMgnt/CertUpdateService/ImportClientCert';
      $http
        .post(url, data)
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }

  // 上传SSL证书文件
  public static uploadCerFile(formData: FormData) {
    return $http.post(UI_REST_FIRMWAREINVENTORY, formData);
  }

  // 导入CA证书
  public static imporCACertificate(fileName: string) {
    let data = { Content: `/tmp/web/${fileName}`, CertificateType: '0' };
    return new Promise((resolve, reject) => {
      const url = '/UI/Rest/AccessMgnt/CertMgnt/ImportCert';
      $http
        .post(url, data)
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }

  // 导入吊销列表
  public static importCerCtrl(fileName: string, id: string) {
    let data = { Content: `/tmp/web/${fileName}`, CertificateType: '0', ID: id };
    return new Promise((resolve, reject) => {
      const url = '/UI/Rest/AccessMgnt/CertMgnt/ImportCertCrl';
      $http
        .post(url, data)
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }

  // 删除吊销列表
  public static delCerCrl(id: string): any {
    return new Promise((resolve, reject) => {
      const url = `/UI/Rest/AccessMgnt/CertMgnt/${id}/DeleteCrlCertificate`;
      $http
        .post(url, {})
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }

  // 导入自定义证书
  public static importDiyCerCtrl(fileName: string, pwd: string) {
    let data = { Content: `/tmp/web/${fileName}`, CertificateType: 'Custom', Password: pwd || '' };
    return new Promise((resolve, reject) => {
      const url = '/UI/Rest/Services/WEBService/ImportCertificate';
      $http
        .post(url, data)
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }

  // 导入服务器证书
  public static importServersCerCtrl(fileName: string) {
    let data = { Content: `/tmp/web/${fileName}`, CertificateType: 'Server'};
    return new Promise((resolve, reject) => {
      const url = '/UI/Rest/Services/WEBService/ImportCertificate';
      $http
        .post(url, data)
        .then((res: any) => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
    });
  }
}
