//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
/* player client
 * keyboard.js
 *
 */
const JS_KEY_SPACE = 0x20;
const JS_KEY_ENTER = 0x0d;

export class KeyBoard {
  public _layout = null;
  public _client;
  public ctx: any;
  public _canvas;
  constructor(client: any) {
    this._client = client;
    this._canvas = client.cvx;

    // 按键事件,绑定整个页面
    document.onkeypress = (e): boolean => {
      this._KeyPress(e);
      return false;
    };
    // 全屏的点击事件
    (document.getElementById('divFullscreen') as HTMLElement).onclick = (): boolean => {
      this._FullScreenClick();
      return false;
    };

    // 单击事件
    this._canvas.onclick = () => {
      this._Click();
      return false;
    };

    // 双击事件
    this._canvas.ondblclick = (): boolean => {
      this._DoubleClick();
      return false;
    };
  }
  
  // 处理空格或者回车键按下的时响应
  _KeyPress(e: any) {
    const keyCode = e.keyCode || e.which || e.charCode;
    if (keyCode === JS_KEY_ENTER || keyCode === JS_KEY_SPACE) {
      this._client._toolbar._PlayClick();
    }
  }

  _Click() {
    this._client._toolbar._PlayClick();
  }

  _FullScreenClick() {}

  _DoubleClick() {
    this._client._toolbar._FullScreenClick();
  }
}
