//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
/* player client
 * client.ts
 */
import { Display } from './display';
import { Communication } from './communication';
import { KeyBoard } from './keyboard';
import { ToolBar } from './toolbar';
import { ProgressBar } from './progressbar';
class Client {
  public _display = null as any;
  public _communication = null as any;
  public _keyboard = null as any;
  public _toolbar = null as any;
  public _progressbar = null as any;
  public _security = null as any;
  public _isRemote = 0;
  public _showMessage;
  public scope: any;
  public ctx: any;
  public cvx: any;

  constructor(scope: any, showMessage: any) {
    this.scope = scope;
    this.cvx = scope.cvx;
    this.ctx = scope.ctx;
    this._showMessage = showMessage;
  }

  public run(ip: string, port: number, videoType: number, key: string) {
    if (videoType > 0) {
      this._isRemote = 1;
    } else {
      this._isRemote = 0;
    }
    // 如果是在线播放，禁掉btnLoop、btnOpen按钮
    if (this._isRemote === 1) {
      (document.getElementById('btnLoop') as HTMLElement).style.display = 'none';
      (document.getElementById('btnOpen') as HTMLElement).style.display = 'none';
    }
    this._display = new Display(this);
    // 如果是在线播放才加载communication模块
    if (this._isRemote === 1) {
      this._communication = new Communication(this, ip, port, videoType, key);
    }
    this._keyboard = new KeyBoard(this);
    this._toolbar = new ToolBar(this);
    this._progressbar = new ProgressBar(this);
  }
}

export function run(scope: any, showMessage: any) {
  const client = new Client(scope, showMessage);

  client.run(
    scope.videoParams.ip,
    scope.videoParams.port,
    scope.videoParams.videoType,
    scope.videoParams.videoKey,
  );
}
