//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export class UdfImageBuilderFile {
  public identifier: any;
  public sourceFile = null as any;
  public children = [] as any;
  public fileType: any;

  public accessTime: any;
  public attributeTime: any;
  public creationTime: any;
  public modificationTIme: any;

  public fileLinkCount: any;
  public parent: any;
  public fileEntryPosition: any;
  public sourceFileArray: any;

  getDirectoryCount() {
    let directoryCount = 0;
    if (this.fileType === 'Directory') {
      directoryCount++;
      for (const childUDFImageBuilderFile of this.children) {
        if (childUDFImageBuilderFile.fileType === 'Directory') {
          directoryCount += childUDFImageBuilderFile.getDirectoryCount();
        }
      }
    }
    return directoryCount;
  }
  
  getFileCount() {
    let fileCount = 0;
    if (this.fileType === 'Directory') {
      for (const childUDFImageBuilderFile of this.children) {
        if (childUDFImageBuilderFile.fileType === 'Directory') {
          fileCount += childUDFImageBuilderFile.getFileCount();
        } else if (childUDFImageBuilderFile.fileType === 'File') {
          fileCount++;
        }
      }
    } else if (this.fileType === 'File') {
      fileCount = 1;
    }
    return fileCount;
  }

  getFileLength() {
    if (this.sourceFile != null) {
      return this.sourceFile.size;
    } else {
      return 0;
    }
  }

  getChildren() {
    return this.children;
  }
}
