//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.

import $http from '@/utils/http-service';

export function getTPCMBasicInfo(): any {
  return $http.get(`/UI/Rest/AccessMgnt/TPCMBasicInfo`);
}

export function getTPCMDetailedInfo(): Promise<any> {
  return $http.get(`/UI/Rest/AccessMgnt/TPCMDetailedInfo`).then(res => res.data.Members);
}

export function getTpcmService(): any {
  return $http.get(`/UI/Rest/AccessMgnt/TpcmService`);
}

export function setTpcmService(param: any): any {
  return $http.patch(`/UI/Rest/AccessMgnt/TpcmService`, param);
}
export function updateService(param: any): any {
  return $http.patch(`/UI/Rest/AccessMgnt/TpcmService/SetStandardDigest`, param);
}

export async function getHardwareIdentity(): Promise<any> {
  const res = await $http.get('/UI/Rest/TrustedComputing/HardwareIdentity');
  const data = (res?.data?.HardwareIdentityMeasured ?? [])
    .map((item: any) => ({
      name: item.Name,
      comparedResult: item.ComparedResult,
      details: normalize(item.Details),
    }));
  data.sort((item1: any, item2: any) => item1.name < item2.name ? -1 : 1);
  return data;
}

export function getSecureBoot(): any {
  return $http.get('/UI/Rest/TrustedComputing/SecureBoot').then(res => normalize(res.data.SecureBootVerification));
}

export function refreshHardwareBase(password?: string): any {
  const params = password ? { ['ReauthKey']: window.btoa(password) } : {};
  const header = {
    ['Content-Type']: 'application/json;charset=utf-8',
    ['From']: 'WebUI',
  };
  return $http.post('/UI/Rest/TrustedComputing/HardwareIdentity/ResetComponentStandardDigest', params, { header });
}

function normalize(rawData: any[]): any {
  return rawData.map(item => {
    const retData: any = {};
    Object.entries(item).map(([key, value]) => {
      retData[`${key[0].toLowerCase()}${key.slice(1)}`] = value === undefined || value === '' ? '--' : value;
    });
    return retData;
  });
}