//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export function getAddParams(
  param: any,
  editData: any,
  baseEditData: any,
  pwdResetPolicySupport: any,
  firstLoginEnabled: any,
): void {
  // 如果是新增用户页面, 则下发所有参数
  param.UserName = editData.userName;
  param.OldUserName = baseEditData.userName;
  param.Password = editData.userPwd1;
  param.RoleId = editData.roleId;
  param.LoginInterface = editData.interfaceChecks;

  param.LoginRule = editData.loginRole;
  // 如果支持密码修改策略，则加上该参数
  if (pwdResetPolicySupport.value) {
    param.FirstLoginPolicy = editData.forceModify;
  }
  if (!firstLoginEnabled.value) {
    param.FirstLoginPolicy = 1;
  }
}

// 获取编辑时的参数
export function getEditParams(
  param: any,
  editData: any,
  baseEditData: any,
  pwdResetPolicySupport: any,
): void {
  // 编辑用户页面，则下发有变化的参数
  if (editData.userName !== baseEditData.userName) {
    param.UserName = editData.userName;
  }

  if (editData.userPwd1 !== baseEditData.userPwd1) {
    param.Password = editData.userPwd1;
  }

  if (editData.roleId !== baseEditData.roleId) {
    param.RoleId = editData.roleId;
  }

  const interfaceStr1 = editData.interfaceChecks.sort().join('');
  const interfaceStr2 = baseEditData.interfaceChecks.sort().join('');
  if (interfaceStr1 !== interfaceStr2) {
    param.LoginInterface = editData.interfaceChecks.sort();
  }

  const ruleStr1 = editData.loginRole.sort().join('');
  const ruleStr2 = baseEditData.loginRole.sort().join('');
  if (ruleStr1 !== ruleStr2) {
    param.LoginRule = editData.loginRole.sort();
  }

  // 如果支持密码修改策略切修改策略有变更，则添加该参数
  if (pwdResetPolicySupport.value && editData.forceModify !== baseEditData.forceModify) {
    param.FirstLoginPolicy = editData.forceModify;
  }
  // snmpv3密码
  if (editData.snmpPwd1 !== baseEditData.snmpPwd1) {
    param.SNMPV3Password = editData.snmpPwd1;
  }
  if (editData.authProtocol !== baseEditData.authProtocol) {
    param.SnmpV3AuthProtocol = editData.authProtocol;
  }
  if (editData.encryProtocol !== baseEditData.encryProtocol) {
    param.SnmpV3PrivProtocol = editData.encryProtocol;
  }
}
