//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { ILdapUserGroup } from '@/model/Users/ldap-interface';

export class LdapGroup implements ILdapUserGroup {
  public ID: number = 0;
  public Name: string = '';
  public RoleID: string = '';
  public RoleLabel: string = '';
  public Folder: string = '';
  public LoginInterface: string[] = [];
  public LoginRule: string[] = [];
  constructor(group?: {
    id: number;
    name: string;
    roleID: string;
    roleLabel: string;
    folder: string;
    loginInterface: string[];
    loginRule: string[];
  }) {
    if (group) {
      this.ID = group.id;
      this.Name = group.name;
      this.RoleID = group.roleID;
      this.RoleLabel = group.roleLabel;
      this.Folder = group.folder;
      this.LoginInterface = group.loginInterface;
      this.LoginRule = group.loginRule;
    }
  }
}
