//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { Certificate, ILdapCertificate } from '@/model/Users/ldap-interface';

export class LdapCertificate implements ILdapCertificate {
  public VerificationEnabled: boolean = false;
  public VerificationLevel: string = '';
  // 表示Crl证书是否已配置
  public CrlVerification: boolean = false;
  public ServerCert: Certificate | null = null;
  public RootCert: Certificate | null = null;
  public IntermediateCert: Certificate[] = [];

  constructor(certificate?: {
    rootCert: any;
    serverCert: any;
    intermediateCert: any;
    crlState: boolean;
    certEnabled: boolean;
    certLevel: string;
  }) {
    if (certificate) {
      this.VerificationEnabled = certificate.certEnabled || false;
      this.VerificationLevel = certificate.certLevel;
      this.CrlVerification = certificate.crlState;
      this.ServerCert = certificate.serverCert;
      this.RootCert = certificate.rootCert;
      this.IntermediateCert = certificate.intermediateCert;
    }
  }
}
