//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { TreeNode } from '../storage-interface';
import { Span } from './span.model';

export class SpanNode implements TreeNode {
  id: string;
  label: string;
  url: string;
  children!: TreeNode[];
  checked: boolean | string;
  active!: boolean;
  disabled: boolean;
  labelId: string;
  readonly componentName: string = 'SpanNode';
  private span!: Span;
  private raidIndex: number;

  constructor(lable: string, url: string, id: string, raidIndex: number, labelId: string) {
    this.id = id;
    this.label = lable;
    this.url = url;
    this.checked = false;
    this.disabled = false;
    this.raidIndex = raidIndex;
    this.labelId = labelId;
  }

  addChildren(children: TreeNode): void {
    if (!this.children) { this.children = []; }
    this.children.push(children);
  }

  set setChildren(children: any) {
    this.children = children;
  }

  get getRaidIndex(): number {
    return this.raidIndex;
  }

  get getUrl(): string {
    return this.url;
  }

  set setSpan(span: Span) {
    this.span = span;
  }

  get getSpan(): Span {
    return this.span;
  }

  get getLabel(): string {
    return this.label;
  }
}
