//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { TreeNode } from '../storage-interface';

export class HotSpareNode implements TreeNode {
  id: string;
  label: string;
  children!: TreeNode[];
  active!: boolean;
  checked: boolean | string;
  labelId: string;
  readonly disabled: boolean = false;
  readonly className: string = 'hotSpareClass';

  constructor(lable: string, id: string, labelId: string) {
    this.id = id;
    this.label = lable;
    this.checked = false;
    this.labelId = labelId;
  }

  addChildren(children: TreeNode): void {
    if (!this.children) { this.children = []; }
    this.children.push(children);
  }

  set setChildren(children: any) {
    this.children = children;
  }
}
