//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { TreeNode } from '../storage-interface';
import { Driver } from './driver.model';

export class DriverNode implements TreeNode {
  id: string;
  label: string;
  url: string;
  active!: boolean;
  parent!: TreeNode[];
  disabled: boolean;
  labelId: string;
  readonly componentName: string = 'DriverNode';
  private driver!: Driver;
  private cryptoEraseSupported: boolean;
  private raidIndex: number | null;
  readonly className: string = 'driverClass';
  private raidType: string | null;

  // 参与逻辑处理数据
  private isRaid: boolean;

  constructor(
    lable: string,
    url: string,
    isRaid: boolean,
    cryptoEraseSupported: boolean,
    id: string,
    raidIndex: number | null,
    labelId: string,
    raidType?: string | null,
  ) {
    this.id = id;
    this.label = lable;
    this.url = url;
    this.isRaid = isRaid;
    this.cryptoEraseSupported = cryptoEraseSupported;
    this.disabled = false;
    this.raidIndex = raidIndex;
    this.labelId = labelId;
    this.raidType = raidType || null;    
  }

  get getRaidIndex(): number | null {
    return this.raidIndex;
  }

  get getIsRaid(): boolean {
    return this.isRaid;
  }


  set setDriver(driver: Driver) {
    this.driver = driver;
  }

  get getDriver(): Driver {
    return this.driver;
  }

  get getCryptoErase() {
    return this.cryptoEraseSupported;
  }

  get getRaidType(): any {
    return this.raidType;
  }
}
