//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { factory } from '../volumes/volumes.service';
import { VolumeNode, StorageTree, SpanNode, Volume, TreeNode } from '../../models';


export function factorySpan(node: SpanNode) {
  const storageTree = StorageTree.getInstance();
  const parentId = node.labelId.split('_')[1];
  let parentVolumn: any;
  const getNode = (nodeArr: any, id: string): any => {
    if (nodeArr && nodeArr.length > 0) {
      nodeArr.forEach(
        (n: TreeNode) => {
          if (n.id === id) {
            parentVolumn = n;
          } else {
            getNode(n?.children, id);
          }
        },
      );
    }
  };
  getNode(storageTree.getFoliages, parentId) as VolumeNode;
  return factory(parentVolumn).then(
    (volume: Volume) => {
      parentVolumn.setVolume = volume;
      const spanNode = parentVolumn.children.filter((child:any) => child.id === node.id)[0] as SpanNode;
      return spanNode.getSpan;
    },

  );
}

