//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export const W_TO_BTU_COEFF = 0.293;
export function wattstoBTUs(value: number | null) {
  // W和BTU的单位换算比
  if (!value) {
    return value;
  }
  const ret = parseFloat(Number(value / W_TO_BTU_COEFF).toFixed(1));
  return ret === 0.0 ? 0 : ret;
}
