//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export function htmlEncode(content: string): string {
  if (typeof content !== 'string') {
    return content;
  }
  if (content.length === 0) {
    return '';
  }
  let result = '';
  result = content.replace(/&/g, '&amp;');
  result = result.replace(/</g, '&lt;');
  result = result.replace(/>/g, '&gt;');
  result = result.replace(/\'/g, '&#39;');
  result = result.replace(/\"/g, '&quot;');
  return result;
}

// 计算图表的option.series[i].markLine.label.distance[0]
export function initLeftDistance(length: number): number {
  let res = 0;
  switch (length) {
    case 1: {
      res = 8;
      break;
    }
    case 2: {
      res = 7;
      break;
    }
    default: {
      res = 1;
    }
  }
  return res;
}