//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { traduction } from '@/utils/language';
import {
  IFields,
  IColumns,
} from '@/model/System/net-interface';

export const linkList = ['Up', 'LinkUp', 'Online', 'Connected'];
export const notLinkList = ['Down', 'LinkDown'];

export const netFields: IFields[] = [
  {
    key: 'Name',
    lable: traduction('IBMC_NETWORK_PORT_NAME'),
  },
  {
    key: 'FirmwareVersion',
    lable: traduction('COMMON_FIXED_VERSION'),
  },
  {
    key: 'DriverName',
    lable: traduction('NET_DRIVER_NAME'),
  },
  {
    key: 'DriverVersion',
    lable: traduction('NET_DRIVER_VERSION'),
  },
  {
    key: 'SpeedMbps',
    lable: traduction('NET_SPEED_RATE'),
    unit: 'Mbps',
  },
  {
    key: 'AutoNeg',
    lable: traduction('NET_AUTOMATIC_NEGOTIATION'),
    judgments: [traduction('STORE_ENABLED'), traduction('DISABLED')],
  },
  {
    key: 'FullDuplex',
    lable: traduction('NET_DUPLEX_FLAG_FROM_MCTP'),
    judgments: [traduction('COMMON_YES'), traduction('COMMON_NO')],
  },
  {
    key: 'BusInfo',
    lable: traduction('BUS_INFO_BDF'),
  },
  {
    key: 'MAC',
    lable: traduction('IBMC_IP_ADDRESS04'),
  },
  {
    key: 'PermanentPhysicalAddress',
    lable: traduction('OTHER_PERMANENT_MACADDR'),
  },
  {
    key: 'Vlans',
    lable: traduction('NET_VLANS'),
  },
  // 以下属性可能不存在
  {
    key: 'LinkSpeedGbps',
    lable: traduction('NET_SPEED_RATE'),
    unit: 'Gbps',
  },
  {
    key: 'WWPN',
    lable: 'WWPN',
  },
  {
    key: 'WWNN',
    lable: 'WWNN',
  },
  {
    key: 'WorkMode',
    lable: traduction('COMMON_WORKING_MODE'),
  },
  {
    key: 'PeerDeviceCredit',
    lable: traduction('NET_RIGHT_CERITICAL'),
  },
  {
    key: 'LocalDeviceCredit',
    lable: traduction('NET_LOCAL_CERITICAL'),
  },
  {
    key: 'TXRateGbps',
    lable: traduction('NET_SEND_RATE'),
    unit: 'Gbps',
  },
  {
    key: 'RXRateGbps',
    lable: traduction('NET_RECIVE_RATE'),
    unit: 'Gbps',
  },
  {
    key: 'RateNegotiationStage',
    lable: traduction('NET_RATE_LEVEL'),
  },
  {
    key: 'PortStatus',
    lable: traduction('PORT_STATUS'),
  },
  {
    key: 'WorkingRate',
    lable: traduction('NET_WORK_RATE'),
    unit: 'Gbps',
  },
];

export const linkViewFields: IFields[] = [
  {
    key: 'SwitchName',
    lable: traduction('NET_SWITCH_NAME'),
  },
  {
    key: 'SwitchConnectionID',
    lable: traduction('NET_SWITCH_ID'),
  },
  {
    key: 'SwitchPortID',
    lable: traduction('NET_SWITCH_PORT_ID'),
  },
  {
    key: 'SwitchVLANID',
    lable: traduction('NET_SWITCH_VLAN_ID'),
  },
];

export const statisticsFieldsTransmitted: IFields[] = [
  {
    key: 'TotalBytesTransmitted',
    lable: traduction('TOTAL_BYTES_TRANSMITTED'),
  },
  {
    key: 'UnicastPacketsTransmitted',
    lable: traduction('UNICAST_PACKETS_TRANSMITTED'),
  },
  {
    key: 'MulticastPacketsTransmitted',
    lable: traduction('MULTICAST_PACKETS_TRANSMITTED'),
  },
  {
    key: 'BroadcastPacketsTransmitted',
    lable: traduction('BROAD_CAST_PACKETS_TRANSMITTED'),
  },
  {
    key: 'SingleCollisionTransmitFrames',
    lable: traduction('SINGLE_COLLISION_TRANSMIT_FRAMES'),
  },
  {
    key: 'MultipleCollisionTransmitFrames',
    lable: traduction('MULTIPLE_COLLISION_TRANSMIT_FRAMES'),
  },
  {
    key: 'LateCollisionFrames',
    lable: traduction('LATE_COLLISION_FRAMES'),
  },
  {
    key: 'ExcessiveCollisionFrames',
    lable: traduction('EXCESSIVE_COLLISION_FRAMES'),
  },
];

export const statisticsFieldsReceived: IFields[] = [
  {
    key: 'TotalBytesReceived',
    lable: traduction('TOTAL_BYTES_TRANSMITTED'),
  },
  {
    key: 'UnicastPacketsReceived',
    lable: traduction('UNICAST_PACKETS_TRANSMITTED'),
  },
  {
    key: 'MulticastPacketsReceived',
    lable: traduction('MULTICAST_PACKETS_TRANSMITTED'),
  },
  {
    key: 'BroadcastPacketsReceived',
    lable: traduction('BROAD_CAST_PACKETS_TRANSMITTED'),
  },
  {
    key: 'FcsReceiveErrors',
    lable: traduction('FCS_RECEIVE_ERRORS'),
  },
  {
    key: 'AlignmentErrors',
    lable: traduction('ALIGNMENT_ERRORS'),
  },
  {
    key: 'RuntPacketsReceived',
    lable: traduction('RUNT_PACKETS_RECEIVED'),
  },
  {
    key: 'JabberPacketsReceived',
    lable: traduction('JABBER_PACKETS_RECEIVED'),
  },
];

export const opticalModuleFieldsInfo: IFields[] = [
  {
    key: 'Manufacturer',
    lable: traduction('COMMON_MANUFACTURER'),
  },
  {
    key: 'SerialNumber',
    lable: traduction('COMMON_SERIALNUMBER'),
  },
  {
    key: 'ProductionDate',
    lable: traduction('PRODUCTION_DATE'),
  },
  {
    key: 'PartNumber',
    lable: traduction('PART_NAME'),
  },
  {
    key: 'PackagingType',
    lable: traduction('PACKAGING_TYPE'),
  },
  {
    key: 'MediumMode',
    lable: traduction('MEDIUM_MODE'),
  },
  {
    key: 'TransceiverType',
    lable: traduction('TRANSCEIVER_TYPE'),
  },
  {
    key: 'SupportedSpeedsMbps',
    lable: traduction('NET_SPEED_RATE'),
  },
  {
    key: 'DeviceType',
    lable: traduction('COMMON_DEVICE_TYPE'),
  },
  {
    key: 'ConnectorType',
    lable: traduction('CONNECTOR_TYPE'),
  },
  {
    key: 'TransferDistance',
    lable: traduction('TRANSFER_DISTANCE'),
  },
  {
    key: 'RxLosState',
    lable: traduction('RX_LOS_STATE'),
    judgments: [traduction('COMMON_YES'), traduction('COMMON_NO')],
  },
  {
    key: 'TxFaultState',
    lable: traduction('TX_FAULT_STATE'),
    judgments: [traduction('COMMON_YES'), traduction('COMMON_NO')],
  },
  {
    key: 'WaveLengthNanometer',
    lable: traduction('WAVE_LENGTH'),
  },
  {
    key: 'Indentifier',
    lable: traduction('INDENTIFIER'),
  },
];

export const ipv4Columns: IColumns[] = [
  {
    title: 'NET_PORT_IPV4',
    key: 'Address',
  },
  {
    title: 'IBMC_IP_ADDRESS02',
    key: 'Mask',
  },
  {
    title: 'NET_GATEWAY',
    key: 'Gateway',
  },
];
export const ipv6Columns: IColumns[] = [
  {
    title: 'NET_PORT_IPV6',
    key: 'Address',
  },
  {
    title: 'IBMC_IP_ADDRESS11',
    key: 'Prefix',
  },
  {
    title: 'NET_GATEWAY',
    key: 'Gateway',
  },
];
