//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';

// 获取虚拟媒体配置信息
export function getVmm() {
  return $http.get('/UI/Rest/Services/VMM');
}

// 获取kvm 加密使能
export function getKvm() {
  return $http.get('/UI/Rest/Services/KVM');
}

// 设置虚拟媒体配置信
export function setVmmService(params: any) {
  return $http.patch('/UI/Rest/Services/VMM', params);
}

// 断开活跃会话
export function getVmmActiveSession() {
  const queryParams = {
    VmmControlType: 'Disconnect',
  };
  return $http.post('/UI/Rest/Services/VMM/Control', queryParams);
}

export function queryTask(url: string) {
  return $http.get(url);
}

// 活跃会话进度查询
export function queryTaskActiveSession(url: string) {
  return $http.get(url);
}