//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { traduction } from '@/utils/language';
import { INtp, INtpData } from '../models/ntp.datatype';

/**
 * NTP的FormControl批量生成方法
 * @param ntpModal 模型
 * @param ntpValue 数值
 */
export function ntpCtrlFactory(
  ntpModal: INtp,
  ntpValue: string[],
  serverData: Record<string, unknown>,
  popoverVisible: any,
): Array<{
    id: string;
    label: string;
    tip: string;
  }> {
  const ntpCtrl = [];
  for (let i = 0; i < ntpModal.count; i++) {
    const id = ntpModal.id + i;
    const label = ntpModal.label + i;
    ntpCtrl[i] = {
      label,
      id,
      tip: ntpModal.tip,
    };
    serverData[id] = ntpValue[i];
    popoverVisible[id] = false;
  }
  return ntpCtrl;
}

export const minPollingIntervalValid = (ntpData: INtpData) => {
  return {
    type: 'number',
    message: traduction('NTP_TIME_TIPS_MIN'),
    trigger: 'change',
    transform: (value: string) => {
      return Number(value);
    },
    validator: (rule: any, value: any, callback: (error?: Error) => void) => {
      if (value > ntpData.maxPollingInterval) {
        callback(new Error());
      } else {
        callback();
      }
    },
  };
};

export const maxPollingIntervalValid = (ntpData: INtpData) => {
  return {
    type: 'number',
    message: traduction('NTP_TIME_TIPS_MAX'),
    trigger: 'change',
    transform: (value: string) => {
      return Number(value);
    },
    validator: (rule: any, value: any, callback: (error?: Error) => void) => {
      if (value < ntpData.minPollingInterval) {
        callback(new Error());
      } else {
        callback();
      }
    },
  };
};
