//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';

// 查询license信息
export function findLicenseInfo() {
  return $http.get('/UI/Rest/BMCSettings/LicenseService');
}

// 安装
export function uploadLicense(fileName: string) {
  return $http.post('/UI/Rest/BMCSettings/LicenseService/InstallLicense', {
    Content: `/tmp/web/${fileName}`,
  });
}

// 导出
export function download(params: any) {
  return $http.post('/UI/Rest/BMCSettings/LicenseService/ExportLicense', params);
}

// 查询task
export function getTask(url: string) {
  return $http.get(url);
}

// 失效
export function licenseInvalidService(params: any) {
  return $http.post('/UI/Rest/BMCSettings/LicenseService/DisableLicense', params);
}

// 删除
export function licenseDelService(params: any) {
  return $http.post('/UI/Rest/BMCSettings/LicenseService/DeleteLicense', params);
}

export function getRandomFileName(fileName: string) {
  return `${Date.now()}_${fileName}`;
}
