//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { reqPath } from '@/api/reqPath';
import $http from '@/utils/http-service';

// 获取规则记录数据
export function getWorknoteData() {
  return new Promise((resolve, reject) => {
    $http
      .get(reqPath.maintance.worknote.workRecord)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 添加工作记录
export function addWorknote(params: any) {
  return new Promise((resolve, reject) => {
    $http
      .post(reqPath.maintance.worknote.workRecord, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 编辑工作记录
export function editWorknote(params: any) {
  return new Promise((resolve, reject) => {
    $http
      .patch(reqPath.maintance.worknote.workRecord, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 删除工作记录
export function delWorknote(id: string) {
  return new Promise((resolve, reject) => {
    $http
      .delete(`${reqPath.maintance.worknote.workRecord}/${id}`)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
