//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { UI_REST_GENERALDOWNLOAD } from '@/api/api';
import { reqPath } from '@/api/reqPath';
import $http from '@/utils/http-service';

/**
 * 获取日志的table数据
 * @param url 请求操作日志地址
 */
export function getLogData(url: string) {
  return new Promise((resolve, reject) => {
    $http
      .get(url)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 获取日志的下载路径
export function downLoadLogUrl(url: string, params: any) {
  return new Promise((resolve, reject) => {
    $http
      .post(url, params)
      .then((res: any) => {
        resolve(res);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 下载操作日志
export function downloadOperateData() {
  const data = {
    Path: '/tmp/web/operate.log',
    TransferProtocol: 'HTTPS',
  };
  return $http.post(UI_REST_GENERALDOWNLOAD, data, { responseType: 'blob' });
}

// 下载运行日志
export function downloadRunData() {
  const data = {
    Path: '/tmp/web/runlog.log',
    TransferProtocol: 'HTTPS',
  };
  return $http.post(UI_REST_GENERALDOWNLOAD, data, { responseType: 'blob' });
}

// 下载安全日志
export function downloadSecurityData() {
  const data = {
    Path: '/tmp/web/security.log',
    TransferProtocol: 'HTTPS',
  };
  return $http.post(UI_REST_GENERALDOWNLOAD, data, { responseType: 'blob' });
}

/**
 * 获取日志的下载进度
 * @param url 下载日志的地址
 * @returns
 */
export function getTaskStateData(url: string) {
  return new Promise((resolve, reject) => {
    $http
      .get(url)
      .then((res: any) => {
        resolve(res);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 下载运行日志
export function downLoadRun() {
  return new Promise((resolve, reject) => {
    $http
      .post(reqPath.maintance.ibmcLog.DownloadRunLog)
      .then((res: any) => {
        resolve(res);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

// 下载安全日志
export function downLoadSecurity() {
  return new Promise((resolve, reject) => {
    $http
      .post(reqPath.maintance.ibmcLog.DownloadSecurityLog)
      .then((res: any) => {
        resolve(res);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}
