//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import Date from '@/utils/date';

/**
 * 判断是否有详情
 * 条件 （status==Asserted && eventsugg不是数字类型  && eventsugg不为null  && eventsugg不为空 && eventsugg ！= N/A.）
 * @param
 * @returns boolean 是/否
 */
export function hasDetails(eventsugg: string, status?: any): boolean {
  let condition;
  if (status) {
    condition =
      eventsugg !== null &&
      typeof eventsugg !== 'number' &&
      eventsugg !== '' &&
      eventsugg?.indexOf('N/A') < 0 &&
      status === 'Asserted';
  } else {
    condition =
      eventsugg !== null &&
      typeof eventsugg !== 'number' &&
      eventsugg !== '' &&
      eventsugg?.indexOf('N/A') < 0;
  }
  if (condition) {
    return true;
  } else {
    return false;
  }
}

/**
 * 将字符串按照一定的规则转换成字符串数组
 * @param str 原始字符串数据
 */
export function dealDetails(str: any, status?: any): any {
  let hasDeatil = false;
  if (status) {
    hasDeatil = hasDetails(str, status);
  } else {
    hasDeatil = hasDetails(str, false);
  }
  if (!hasDeatil) {
    return undefined;
  }
  const htmlValue: string[] = [];
  const list = str.split('@#AB;');
  list.forEach((strValue: string) => {
    htmlValue.push(strValue);
  });
  return htmlValue;
}

// 当前告警数据排序
export function sort(arr: object[]) {
  if (arr.length === 0) {
    return arr;
  }
  arr.sort((a: any, b: any) => {
    return new Date(b.createTime).getTime() - new Date(a.createTime).getTime();
  });
  let count = arr.length;
  arr.forEach((item :any) => {
    item.orderNumber = count;
    count--;
  });
  return arr;
}

// 处理日期时间
export function dealDate(date: string) {
  if (date === '') {
    return '';
  }
  const tmpDate = new Date(date.substring(0, 19).replace(/\s/, 'T'));
  return new Date(tmpDate).pattern('yyyy-MM-dd HH:mm:ss');
}

// 时间转换成字符串
export function dateToStr(date: any, isStart: number) {
  const y = date.getFullYear();
  let m = (date.getMonth() + 1).toString();
  let d = date.getDate();
  if (m < 10) {
    m = `0${m}`;
  }
  if (d < 10) {
    d = `0${d}`;
  }
  if (isStart) {
    return `${y}-${m}-${d} 00:00:00`;
  } else {
    return `${y}-${m}-${d} 23:59:59`;
  }
}

// 过滤对象中的空值
export function deleteNULL(obj: object) {
  for (const key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key) && (obj[key] === null || obj[key] === '')) {
      delete obj[key];
    }
  }
  return obj;
}

/**
 * 计算指定的日期前的时间
 * @param day 指定的几天前 如1，代表一天前 number
 */
export function _caculateTimeGap(day: number) {
  let start = '';
  let end = '';
  let dateArray: any = [];
  let currentAlarmEndTime = sessionStorage.getItem('DateTime');
  if (currentAlarmEndTime) {
    currentAlarmEndTime = currentAlarmEndTime.slice(0, 19);
    currentAlarmEndTime = currentAlarmEndTime.replace('T', ' ');
    end = currentAlarmEndTime;
    dateArray = end.split(' ');
  }

  if (day === 1) {
    start = `${dateArray[0]} 00:00:00`;
  } else {
    const splitDatePre = dateArray[0].split('-');
    const dateTime = new Date(
      Date.UTC(Number(splitDatePre[0]), Number(splitDatePre[1]) - 1, Number(splitDatePre[2])),
    );
    let dateTimeStr = dateTime.setDate(dateTime.getUTCDate() - day);
    dateTimeStr = new Date(dateTimeStr).pattern('yyyy-MM-dd');
    start = `${dateTimeStr} ${dateArray[1]}`;
  }
  return { start, end };
}

/**
 * 将时间转换成字符串
 * @param date 要转换的时间
 * @param isStart 开始还是结束标志 1 开始 0 结束
 * @returns 返回转换后的时间字符串
 */
export function _dateToStr(date: any, isStart: number) {
  const y = date.getFullYear();
  let m = (date.getMonth() + 1).toString();
  let d = date.getDate();
  if (m < 10) {
    m = `0${m}`;
  }
  if (d < 10) {
    d = `0${d}`;
  }
  if (isStart) {
    return `${y}-${m}-${d} 00:00:00`;
  } else {
    return `${y}-${m}-${d} 23:59:59`;
  }
}
