//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface IPortProps {
  Port?: string;
  SparePort?: string;
  Enabled?: boolean;
}

export interface IPort {
  HTTP?: IPortProps;
  NAT?: IPortProps;
  HTTPS?: IPortProps;
  SSH: IPortProps;
  KVM?: IPortProps;
  VMM?: IPortProps;
  VNC?: IPortProps;
  SNMPAgent?: IPortProps;
  Video?: IPortProps;
  IPMILANRMCP?: IPortProps;
  IPMILANRMCPPlus?: IPortProps;
}

export interface IPortListItem {
  name: string;
  tipState1: boolean;
  tipState2: boolean;
  label: string;
  port1: string;
  port1Edit: string;
  port1Default: string;
  port2: string;
  port2Edit: string;
  port2Default: string;
  enabled: boolean;
  enabledEdit: boolean;
  index: number;
  id1: string;
  id2: string;
  alias: string;
}
