//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { UploadFile } from 'element-plus/es/components/upload/src/upload';

export interface IResponse {
  data: any;
  config: any;
  headers: any;
  status: number;
  statusText: string;
}

export interface IError {
  code?: string;
  message?: string;
  relation?: string;
}

export interface IGeneric {
  fanSupport: boolean;
  ibmaSupport: boolean;
  fdmSupport: boolean;
  licenseSupport: boolean;
  spSupport: boolean;
  usbSupport: boolean;
  smsSupport: boolean;
  armSupport: boolean;
  partitySupport: boolean;
  ibmaRunning: boolean;
  tceSupport: boolean;
  tpcmSupport: boolean;
  secureBootVerificationEnabled: boolean;
  copyRight: string;
  currentTime: string;
  customizedId: number;
  healthSummary: { critical: number; major: number; minor: number };
  powerState: string;
  uidState: string;
  storageConfigReady: boolean;
  customeCertFlag: boolean;
  powerPredictSupported: boolean; 
  multihostSupported: boolean;
  kvmSupported: boolean;
  vmmSupported: boolean;
  vncSupported: boolean;
  snmpSupported: boolean;
  rmcpSupported: boolean;
  computeSupported: boolean;
  sensorSupported: boolean;
  assetChangeEnabled: boolean;
  powerSupplySupported: boolean;
  powerConverterSupported: boolean;
  dynamicEnergySavingSupported: boolean;
  langSupported: Partial<{
    zh: boolean;
    en: boolean;
    ja: boolean;
    fr: boolean;
    ru: boolean;
  }>;
}

export interface IUserInfo {
  loct?: {
    uid?: number;
    un?: string;
    uip?: string;
    ur?: string[];
    to?: string;
    rn?: string;
    lip?: string;
    ltime?: string;
    isValidVideoUser?: false;
    sn?: string;
    locale?: string;
    pName?: string;
    vid?: string;
    smsName?: string;
    pSN?: string;
    fanspt?: boolean;
    fdmspt?: boolean;
    ibmaspt?: boolean;
    ibmarun?: boolean;
    tcespt?: boolean;
    licensespt?: boolean;
    powprespt?: boolean;
    usbspt?: boolean;
    spspt?: boolean;
    nopwd?: boolean;
    platform?: string;
    privil?: string[];
    twofac?: boolean;
    isLogin?: boolean;
    customizedId?: number;
    unitspt?: boolean;
    sensorLocation?: boolean;
    computeDomain?: boolean;
    multihost?: boolean;
    assetChange?: boolean;
    powerSupplySupported?: boolean;
    powerConverterSupported?: boolean;
  };
  glob?: {
    ibmcTime?: Promise<any>;
    ibmaResolve?: Promise<any>;
    fqdn?: string;
    langSet?: string;
    copyright?: string;
    pwdCheck?: boolean;
  };
}

// 二级菜单结构
export interface ISecondMenu {
  label: string;
  router: string;
  iconClass: string;
  id: string;
  navId: string;
  hide: boolean;
}

// 三级菜单结构
export interface IThirdMenu {
  index: string;
  label: string;
  router: string;
  iconClass?: string;
  id?: string;
  navId?: string;
}

// 主菜单结构
export interface IMainMenu {
  id: string;
  label: string;
  router: string;
  children: Array<ISecondMenu>;
  dropState: boolean;
}

// 顶部告警数量结构
export interface IWarnings {
  critical: number;
  major: number;
  minor: number;
}

export interface ITableColumns {
  title: string;
  width?: string;
  show?: boolean;
  [propName: string]: any;
}

export interface ISensorsTable {
  id?: number;
  name?: string;
  readingValue?: string;
  status?: string;
  lowerThresholdFatal?: string;
  lowerThresholdCritical?: string;
  lowerThresholdNonCritical?: string;
  upperThresholdNonCritical?: string;
  upperThresholdCritical?: string;
  upperThresholdFatal?: string;
  [propName: string]: any;
}

export interface IAssetChangeTable {
  type: string;
  location: string;
  currentHash: string;
  standardHash: string;
  hashInfo: string;
  status: boolean;
  info: string;
}

export interface ITabsView {
  index: string;
  label: string;
  name: string;
  router: string;
  [propName: string]: any;
}

export enum sensorUnit {
  RPM = 'RPM',
  Volts = 'V',
  'degrees C' = '℃',
  Watts = 'W',
  Amps = 'A'
}

// Dialog配置对象
export interface IButton {
  label?: string;
  id?: string;
  hide?: boolean;
}

export interface IDialogConfig {
  title: string;
  content: string | string[];
  id?: string;
  size?: string;
  width?: string;
  type?: string;
  modalClass?: string;
  alignItems?: string;
  closeIcon?: boolean;
  closeOnEsc?: boolean;
  closeOnClickModal?: boolean;
  backDrop?: boolean;
  okButton?: IButton;
  cancelButton?: IButton;
  saveButton?: IButton;
}

export interface ITableRow {
  id: number;
  isOperation: boolean;
  roleName: string;
  userConfigEnabled: boolean;
  basicConfigEnabled: boolean;
  remoteControlEnabled: boolean;
  VMMEnabled: boolean;
  securityConfigEnabled: boolean;
  powerControlEnabled: boolean;
  diagnosisEnabled: boolean;
  queryEnabled: boolean;
  configureSelfEnabled: boolean;
  isSave: boolean;
  isEdit: boolean;
  sequence: number;
}

export enum RoleName {
  administrator = 'Administrator',
  operator = 'Operator',
  commonuser = 'CommonUser',
  noAccess = 'NoAccess',
  customRole1 = 'CustomRole1',
  customRole2 = 'CustomRole2',
  customRole3 = 'CustomRole3',
  customRole4 = 'CustomRole4',
  customRole5 = 'CustomRole5',
  customRole6 = 'CustomRole6',
  customRole7 = 'CustomRole7',
  customRole8 = 'CustomRole8',
  customRole9 = 'CustomRole9',
  customRole10 = 'CustomRole10',
  customRole11 = 'CustomRole11',
  customRole12 = 'CustomRole12',
  customRole13 = 'CustomRole13',
  customRole14 = 'CustomRole14',
  customRole15 = 'CustomRole15',
  customRole16 = 'CustomRole16',
}

export interface IUploadConfig {
  disabled?: boolean;
  id?: string;
  action?: string;
  headers?: any;
  method?: string;
  width?: number;
  name?: string;
  data?: any;
  type?: string;
  isAutoUpload?: boolean;
  accept?: string;
  isNeedClearError?: boolean;
  isCustomUpload?: boolean;
  onAddItem?: (file: UploadFile, list: UploadFile[], msg?: any, upload?: any) => boolean;
  onAddItemSuccess?: (file: UploadFile) => void;
  onError?: (error: any, file: UploadFile, list: UploadFile[]) => void;
  onSuccess?: (response: any, file: UploadFile, list: UploadFile[]) => void;
  onBeforeUpload?: (file: UploadFile) => void;
  onPreview?: (file: UploadFile) => void;
  onRemove?: (file: UploadFile, list: UploadFile[]) => void;
  onProgress?: (event: any, file: UploadFile, list: UploadFile[]) => void;
  onBeforeRemove?: (file: UploadFile, list: UploadFile[]) => void;
  [propName: string]: any;
}

// 顶部导航数据结构
export interface INavData {
  health: {
    critical: number;
    major: number;
    minor: number;
  };
  powerState: string;
  uidState: string;
}

export interface IAssetInventoryTable {
  id?: number;
  assetTag?: string;
  assetType?: string;
  assetName?: string;
  partNumber?: string;
  sn?: string;
  firmwareVersion?: string;
  pcbVersion?: string;
  tradeName?: string;
  manufactureDate?: string;
  [propName: string]: any;
}
