//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { IMainMenu, ISecondMenu } from '@/model/base-interface';
import mainMenu from './menu-list';
import { defineStore } from 'pinia';

const useMenuStore = defineStore('menu', {
  state: () => {
    return {
      mainMenu,
    };
  },
  getters: {},
  actions: {
    setChildMenu(payload: { mainId: string; subIds: string[]; supported: boolean }): void {
      const menus = this.mainMenu.filter((item: IMainMenu) => item.id === payload.mainId)[0];
      menus.children.forEach((item: ISecondMenu) => {
        if (payload.subIds.includes(item.id)) {
          item.hide = !payload.supported;
        }
      });
    },
  },
});

export default useMenuStore;
