//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { armGuard } from '@/apps/app-bmc/guard/arm.guard';
import { cpuGuard } from '@/apps/app-bmc/guard/cpu.guard';
import { storageGuard } from '@/apps/app-bmc/guard/storage.guard';
import { RouteRecordRaw } from 'vue-router';
const biosRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/system/bios-settings/bios',
    component: () => import('@/pages/System/BiosConfig/Bios/Bios.vue'),
    beforeEnter: storageGuard,
  },
  {
    path: '/navigate/system/bios-settings/cpu',
    component: () => import('@/pages/System/BiosConfig/CPU/CPU.vue'),
    beforeEnter: [armGuard, cpuGuard],
  },
  {
    path: '/navigate/system/bios-settings/setting',
    component: () => import('@/pages/System/BiosConfig/Setting/setting.vue'),
    beforeEnter: storageGuard,
  },
  {
    path: '',
    redirect: '/navigate/system/bios-settings/bios',
    beforeEnter: storageGuard,
  },
];
export default biosRoutes;
