//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouteRecordRaw } from 'vue-router';
import { snmpGuard } from '@/apps/app-bmc/guard/snmp.guard';
import { vmmGuard } from '@/apps/app-bmc/guard/vmm.guard';
import { vncGuard } from '@/apps/app-bmc/guard/vnc.guard';
import { kvmMultiGuard } from '@/apps/app-bmc/guard/kvmMulti.guard';

const systemRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/service/port',
    component: () => import('@/pages/Service/Port/Port.vue'),
  },
  {
    path: '/navigate/service/web',
    component: () => import('@/pages/Service/Web/Web.vue'),
  },
  {
    path: '/navigate/service/kvm',
    component: () => import('@/pages/Service/Kvm/Kvm.vue'),
    beforeEnter: [kvmMultiGuard],
  },
  {
    path: '/navigate/service/vmm',
    component: () => import('@/pages/Service/Vmm/Vmm.vue'),
    beforeEnter: [vmmGuard],
  },
  {
    path: '/navigate/service/vnc',
    component: () => import('@/pages/Service/Vnc/Vnc.vue'),
    beforeEnter: [vncGuard],
  },
  {
    path: '/navigate/service/snmp',
    component: () => import('@/pages/Service/Snmp/Snmp.vue'),
    beforeEnter: [snmpGuard],
  },
  {
    path: '/navigate/service/ipmi',
    component: () => import('@/pages/Service/IPMI/IPMI.vue'),
  },
  {
    path: '',
    redirect: '/navigate/service/port',
  },
];
export default systemRoutes;
