//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { storageGuard } from '@/apps/app-bmc/guard/storage.guard';
import { basicGuard } from '@/apps/app-bmc/guard/basic.guard';
import { RouteRecordRaw } from 'vue-router';
const spRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/manager/sp/sp-manage',
    component: () => import('@/pages/Manager/Sp/SpManage/SpManage.vue'),
    beforeEnter: storageGuard,
  },
  {
    path: '/navigate/manager/sp/sp-task',
    component: () => import('@/pages/Manager/Sp/SpTask/SpTaskTabs.vue'),
    beforeEnter: [storageGuard, basicGuard],
  },
  {
    path: '',
    redirect: '/navigate/manager/sp/sp-manage',
    beforeEnter: storageGuard,
  },
];
export default spRoutes;
