//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { forbidGuard } from '@/apps/app-bmc/guard/forbid.guard';
import { spGuard } from '@/apps/app-bmc/guard/sp.guard';
import { ibmaGuard } from '@/apps/app-bmc/guard/ibma.guard';
import { licenseGuard } from '@/apps/app-bmc/guard/license.guard';
import { RouteRecordRaw } from 'vue-router';
import spRoutes from './sp/sp.router';
import { ibmcManageMentSecondMenu } from '@/apps/app-bmc/store/menu-list';

const managerRoutes: Array<RouteRecordRaw> = [
  {
    path: ibmcManageMentSecondMenu[0].router,
    component: () => import('@/pages/Manager/Network/Network.vue'),
  },
  {
    path: ibmcManageMentSecondMenu[1].router,
    component: () => import('@/pages/Manager/Ntp/Ntp.vue'),
  },
  {
    path: ibmcManageMentSecondMenu[2].router,
    component: () => import('@/pages/Manager/Upgrade/Upgrade.vue'),
  },
  {
    path: ibmcManageMentSecondMenu[3].router,
    component: () => import('@/pages/Manager/ConfigUpdate/ConfigUpdate.vue'),
  },
  {
    path: ibmcManageMentSecondMenu[4].router,
    component: () => import('@/pages/Manager/Language/Language.vue'),
  },
  {
    path: ibmcManageMentSecondMenu[5].router,
    component: () => import('@/pages/Manager/License/License.vue'),
    beforeEnter: [licenseGuard],
  },
  {
    path: ibmcManageMentSecondMenu[6].router,
    component: () => import('@/pages/Manager/Ibma/Ibma.vue'),
    beforeEnter: [ibmaGuard],
  },
  {
    path: ibmcManageMentSecondMenu[7].router,
    component: () => import('@/pages/Manager/Sp/Sp.vue'),
    redirect: '/navigate/manager/sp/sp-manage',
    children: spRoutes,
    beforeEnter: [spGuard],
  },
  {
    path: ibmcManageMentSecondMenu[8].router,
    component: () => import('@/pages/Manager/Usb/Usb.vue'),
  },
  {
    path: '',
    redirect: '/navigate/manager/network',
  },
];
export default managerRoutes;
