//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouteRecordRaw } from 'vue-router';
import { assetChangeGuard } from '@/apps/app-bmc/guard/assetChange.guard';
import { forbidGuard } from '@/apps/app-bmc/guard/forbid.guard';

const assetRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/maintenance/asset-maintance/asset-retire',
    component: () => import('@/pages/Maintance/AssetMaintance/components/AssetRetire.vue'),
  },
  {
    path: '/navigate/maintenance/asset-maintance/asset-inventory',
    component: () => import('@/pages/Maintance/AssetMaintance/components/AssetInventory.vue'),
  },
  {
    path: '/navigate/maintenance/asset-maintance/asset-change',
    component: () => import('@/pages/Maintance/AssetMaintance/components/AssetChange.vue'),
    beforeEnter: [assetChangeGuard],
  },
  {
    path: '/navigate/maintenance/asset-maintance/supply-chain-config',
    component: () => import('@/pages/Maintance/AssetMaintance/components/SupplyChainConfig.vue'),
    beforeEnter: [forbidGuard],
  },
];
export default assetRoutes;
