//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouteRecordRaw } from 'vue-router';
import LoginComponent from '../Login/Login.vue';
import navRoutes from './navigate/navigate-router';
import { kvmGuard } from '../guard/kvm.guard';
import { pageStyleGuard } from '../guard/pageStyle.guard';

// 匹配不存在的路由的格式为 /:pathMatch(.*)*
const appRoutes: Array<RouteRecordRaw> = [
  {
    path: '/login',
    component: LoginComponent,
    beforeEnter: [pageStyleGuard, kvmGuard],
  },
  {
    path: '/navigate',
    component: () => import('@/apps/app-bmc/Navigate/Navigate.vue'),
    children: navRoutes,
  },
  {
    path: '/kvm_h5',
    name: 'KVM',
    component: () => import('@/pages/VirtualControl/KvmH5/KvmH5.vue'),
  },
  {
    path: '/videoPlayer/:id',
    component: () => import('@/pages/VirtualControl/VideoPlayer/VideoPlayer.vue'),
  },
  {
    path: '',
    redirect: '/login',
  },
];
export default appRoutes;
