//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouterChangeReason } from '@/model/base-enum';
import { getGenericInfo } from '@/services/header/header.service';
import { getEnergySavingService } from '@/pages/System/Power/services/power.services';
import { getStoreData, setStoreData } from '@/utils/composition';
import { getRandomNumber } from '@/utils/utils';
import { NavigationGuardNext, RouteLocationNormalized } from 'vue-router';

export function powerPredictedGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext,
): void {
  const supported = getStoreData('loct', 'powprespt');
  if (supported !== null && supported !== undefined) {
    if (supported === false) {
      setStoreData('event', 'routeChangeError', RouterChangeReason.invalid + getRandomNumber());
    } else {
      next();
    }
  } else {
    getGenericInfo().then(res => {
      if (res.powerPredictSupported === false) {
        setStoreData('event', 'routeChangeError', RouterChangeReason.invalid + getRandomNumber());
      } else {
        next();
      }
    });
  }
}

export function energySavingGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext,
): void {
  const supported = getStoreData('loct', 'dynamicEnergySavingSupported');
  if (supported !== null && supported !== undefined) {
    if (supported === false) {
      setStoreData('event', 'routeChangeError', RouterChangeReason.invalid + getRandomNumber());
    } else {
      next();
    }
  } else {
    getGenericInfo().then(res => {
      if (res.dynamicEnergySavingSupported === false) {
        setStoreData('event', 'routeChangeError', RouterChangeReason.invalid + getRandomNumber());
      } else {
        next();
      }
    });
  }
}

export function infoPredictedGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext,
): void {
  const powerSupplySupported = getStoreData('loct', 'powerSupplySupported');
  const powerConverterSupported = getStoreData('loct', 'powerConverterSupported');
  if (!powerSupplySupported && !powerConverterSupported) {
    next('/navigate/system/power/capping');
  } else if (!powerSupplySupported && powerConverterSupported) {
    next('/navigate/system/power/converter');
  } else {
    next();
  }
}

export function powerConverterGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext,
): void {
  const supported = getStoreData('loct', 'powerConverterSupported');
  if (supported !== null && supported !== undefined) {
    if (supported === false) {
      setStoreData('event', 'routeChangeError', RouterChangeReason.invalid + getRandomNumber());
    } else {
      next();
    }
  } else {
    getGenericInfo().then(res => {
      if (res.powerConverterSupported === false) {
        setStoreData('event', 'routeChangeError', RouterChangeReason.invalid + getRandomNumber());
      } else {
        next();
      }
    });
  }
}
