//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouterChangeReason } from '@/model/base-enum';
import { getGenericInfo } from '@/services/header/header.service';
import { getStoreData, setStoreData } from '@/utils/composition';
import { RouteLocationNormalized } from 'vue-router';

// 该守卫主要是确认平台的类型，是Arm还是X86
export function platformGuard(to: RouteLocationNormalized): Promise<any> | boolean | undefined {
  const supported = getStoreData('loct', 'platform');
  if (supported !== null && supported !== undefined) {
    return true;
  } else {
    return new Promise(resolve => {
      getGenericInfo()
        .then(res => {
          const platform = res.armSupport ? 'Arm' : 'x86';
          resolve(platform);
        })
        .catch(() => {
          return false;
        });
    });
  }
}
