//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';
import $sensitive from '@/utils/sensitive';
import {
  UI_REST_LOGIN,
  UI_REST_RIGHT_MANAGEMENT,
  UI_REST_ADVANCE_SECURITY,
  UI_RESET_SESSIONS,
  UI_RESET_TWOFAC,
  UI_RESET_KRBSSO,
  UI_REST_KVM,
} from '@/api/api';
import { setStoreData } from '@/utils/composition';

// 登录
export function localLogin(param: any): Promise<any> {
  return $http.post(UI_REST_LOGIN, param);
}

// 登录，加密版本
export async function localLoginSensitive(paramGen: (key: string) => any): Promise<any> {
  const encryptedPaths = ['UserName', 'Password'];
  return await $sensitive(encryptedPaths, paramGen).post(UI_REST_LOGIN);
}

// 用户权限查询
export function getPrivils(): Promise<any> {
  return $http.get(UI_REST_RIGHT_MANAGEMENT);
}

// 查询是否开启密码检查, 是否开启移动定制化
export function getPwdCheck(): Promise<any> {
  return $http.get(UI_REST_ADVANCE_SECURITY).then((res: any) => {
    setStoreData('glob', 'systemLocked', res?.data?.SystemLockDownEnabled || false);
    setStoreData('glob', 'localAccountPasswordRulePolicy', res?.data?.LocalAccountPasswordRulePolicy || 'Default');
    setStoreData('glob', 'localAccountPasswordPattern', new RegExp(res?.data?.LocalAccountPasswordPattern || ''));
    setStoreData('glob', 'snmpCommunityPasswordRulePolicy', res?.data?.SnmpCommunityPasswordRulePolicy || 'Default');
    setStoreData('glob', 'snmpCommunityPasswordPattern', new RegExp(res?.data?.SnmpCommunityPasswordPattern || ''));
    setStoreData('glob', 'vncPasswordRulePolicy', res?.data?.VNCPasswordRulePolicy || 'Default');
    setStoreData('glob', 'vncPasswordPattern', new RegExp(res?.data?.VNCPasswordPattern || ''));
    return res;
  });
}

export function getSessions(headers?: any): Promise<any> {
  if (headers) {
    return $http.get(UI_RESET_SESSIONS, headers);
  }
  return $http.get(UI_RESET_SESSIONS);
}

export function getTwoFactor(): Promise<any> {
  return $http.get(UI_RESET_TWOFAC);
}

export function modifyUserInfo(url: string, params: any): Promise<any> {
  return $http.patch(url, params);
}

export function getV1Info() {
  return $http.get(UI_REST_LOGIN);
}

export function getSSOKerberos(): Promise<any> {
  return $http.get(UI_RESET_KRBSSO, {
    headers: {
      'Content-Type': 'application/text;charset=utf-8',
    },
    responseType: 'text',
  });
}

export function getKvmHandler(url: string) {
  return $http.get(url);
}

export function getDiyImgUrl(): Promise<any> {
  return $http.get('/volcanoLogo.svg');
}

export function kvmLogin(params: any): Promise<any> {
  let connectParam = '';
  for (const key in params) {
    if (Object.prototype.hasOwnProperty.call(params, key)) {
      const value = encodeURIComponent(params[key]);
      connectParam += `${key}=${value}&`;
    }
  }
  connectParam = connectParam.substring(0, connectParam.length - 1);
  const headers = { 'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8' };
  return $http.post(UI_REST_KVM, connectParam, { headers });
}
