// Copyright (c) Huawei Technologies Co., Ltd. 2022-2024. All rights reserved.
// 
// this file licensed under the Mulan PSL v2.
// You can use this software according to the terms and conditions of the Mulan PSL v2.
// You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
//
// THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
// PURPOSE.
// See the Mulan PSL v2 for more details.
const fs = require('fs');
// 目标添加文件夹路径
const distPath = './src';
// 目标添加文件类型
const fileTypes = ['ts'];
const travelFuc = require('./travel');
// 版权信息模板
const template = `// Copyright (c) Huawei Technologies Co., Ltd. 2022-2024. All rights reserved.
// 
// this file licensed under the Mulan PSL v2.
// You can use this software according to the terms and conditions of the Mulan PSL v2.
// You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
//
// THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
// PURPOSE.
// See the Mulan PSL v2 for more details.
`;
// 版权信息模板前缀
const templatePrefix = '// Copyright';

travelFuc.travel(distPath, pathname => {
  function getFileType(path) {
    const splits = path.split('.');
    return splits[splits.length - 1] || '';
  }
  if (pathname && fileTypes.includes(getFileType(pathname))) {
    try {
      const fileContent = fs.readFileSync(pathname, 'utf-8') || '';
      // 已添加信息不需要重复添加
      if (fileContent.indexOf(templatePrefix) !== 0) {
        const temp = template + fileContent;
        fs.writeFileSync(pathname, temp, 'utf-8');
      }
    } catch (err) {
      throw new Error(err);
    }
  }
});