//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export const permissionManagementData = {
  Count: 8,
  Members: [
    {
      ID: 4,
      Name: 'Administrator',
      QueryEnabled: true,
      ConfigureSelfEnabled: true,
      UserConfigEnabled: true,
      BasicConfigEnabled: true,
      RemoteControlEnabled: true,
      VMMEnabled: true,
      SecurityConfigEnabled: true,
      DiagnosisEnabled: true,
      PowerControlEnabled: true
    },
    {
      ID: 3,
      Name: 'Operator',
      QueryEnabled: true,
      ConfigureSelfEnabled: true,
      UserConfigEnabled: false,
      BasicConfigEnabled: true,
      RemoteControlEnabled: true,
      VMMEnabled: true,
      SecurityConfigEnabled: false,
      DiagnosisEnabled: false,
      PowerControlEnabled: true
    },
    {
      ID: 2,
      Name: 'CommonUser',
      QueryEnabled: true,
      ConfigureSelfEnabled: true,
      UserConfigEnabled: false,
      BasicConfigEnabled: false,
      RemoteControlEnabled: false,
      VMMEnabled: false,
      SecurityConfigEnabled: false,
      DiagnosisEnabled: false,
      PowerControlEnabled: false
    },
    {
      ID: 15,
      Name: 'NoAccess',
      QueryEnabled: false,
      ConfigureSelfEnabled: false,
      UserConfigEnabled: false,
      BasicConfigEnabled: false,
      RemoteControlEnabled: false,
      VMMEnabled: false,
      SecurityConfigEnabled: false,
      DiagnosisEnabled: false,
      PowerControlEnabled: false
    },
    {
      ID: 5,
      Name: 'CustomRole1',
      QueryEnabled: true,
      ConfigureSelfEnabled: true,
      UserConfigEnabled: false,
      BasicConfigEnabled: true,
      RemoteControlEnabled: true,
      VMMEnabled: true,
      SecurityConfigEnabled: true,
      DiagnosisEnabled: false,
      PowerControlEnabled: true
    },
    {
      ID: 6,
      Name: 'CustomRole2',
      QueryEnabled: true,
      ConfigureSelfEnabled: true,
      UserConfigEnabled: false,
      BasicConfigEnabled: false,
      RemoteControlEnabled: true,
      VMMEnabled: true,
      SecurityConfigEnabled: true,
      DiagnosisEnabled: true,
      PowerControlEnabled: true
    },
    {
      ID: 7,
      Name: 'CustomRole3',
      QueryEnabled: true,
      ConfigureSelfEnabled: true,
      UserConfigEnabled: false,
      BasicConfigEnabled: false,
      RemoteControlEnabled: false,
      VMMEnabled: false,
      SecurityConfigEnabled: false,
      DiagnosisEnabled: false,
      PowerControlEnabled: false
    },
    {
      ID: 8,
      Name: 'CustomRole4',
      QueryEnabled: true,
      ConfigureSelfEnabled: true,
      UserConfigEnabled: false,
      BasicConfigEnabled: false,
      RemoteControlEnabled: false,
      VMMEnabled: false,
      SecurityConfigEnabled: false,
      DiagnosisEnabled: false,
      PowerControlEnabled: false
    }
  ]
};

export const securityBulletinData = {
  DefaultSecurityBanner:
    'WARNING! This system is PRIVATE and PROPRIETARY and may only be accessed by authorized users. Unauthorized use of the system is prohibited. The owner, or its agents, may monitor any activity or communication on the system. The owner, or its agents, may retrieve any information stored within the system. By accessing and using the system, you are consenting to such monitoring and information retrieval for law enforcement and other purposes.',
  Enabled: true,
  SecurityBanner: '11.16~11.20，255.255.255.255占用，用来录制仿真环境！！！',
};

export const loginRulesData = {
  Count: 3,
  Members: [
    {
      ID: 0,
      IP: '',
      Mac: '',
      EndTime: '2021-09-09 15:56',
      Status: true,
      StartTime: '2021-09-06 15:46'
    },
    {
      ID: 1,
      IP: '',
      Mac: '',
      EndTime: '',
      Status: true,
      StartTime: ''
    },
    {
      ID: 2,
      IP: '',
      Mac: '',
      EndTime: '',
      Status: false,
      StartTime: ''
    }
  ]
};

export const securityEnhanceData = {
  AccountInactiveTimelimitDays: 0,
  AccountLockoutDuration: 5,
  AccountLockoutThreshold: 5,
  AntiDNSRebindEnabled: false,
  AvailableUsers: ['Administrator', '', 'LkAdmin01'],
  CertificateOverdueWarningTime: 91,
  EmergencyLoginUser: '',
  MinimumPasswordAgeDays: 0,
  MinimumPasswordLength: 8,
  OSAdministratorPrivilegeEnabled: true,
  PasswordComplexityCheckEnabled: true,
  PasswordValidityDays: 0,
  PreviousPasswordsDisallowedCount: 0,
  SSHAuthenticationMode: 'Password',
  TLSVersion: ['TLS1.2', 'TLS1.3'],
  SystemLockDownEnabled: false
};

export const patchSecurityEnhanceData = {
  AccountInactiveTimelimitDays: 0,
  AccountLockoutDuration: 5,
  AccountLockoutThreshold: 5,
  AntiDNSRebindEnabled: true,
  AvailableUsers: ['Administrator', '', 'LkAdmin01'],
  CertificateOverdueWarningTime: 91,
  EmergencyLoginUser: 'Administrator',
  MinimumPasswordAgeDays: 0,
  MinimumPasswordLength: 8,
  OSAdministratorPrivilegeEnabled: true,
  PasswordComplexityCheckEnabled: true,
  PasswordValidityDays: 0,
  PreviousPasswordsDisallowedCount: 0,
  SSHAuthenticationMode: 'Password',
  TLSVersion: ['TLS1.2', 'TLS1.3'],
  SystemLockDownEnabled: false
};
