//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export default {
  Count: 5,
  Count123: 5,
  Members: [
    {
      LoginInterface: ['Web', 'SNMP', 'IPMI', 'SSH', 'SFTP', 'Local', 'Redfish'],
      LoginRule: [],
      SnmpV3AuthProtocol: 'SHA',
      PasswordValidityDays: null,
      SSHPublicKeyHash: null,
      SNMPEncryptPwdInit: true,
      Actions: {
        'Account.DeleteSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/2/DeleteSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/2/DeleteSSHPublicKey'
        },
        'Account.DeleteMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteCertificate'
        },
        'Account.ImportSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/2/ImportSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/2/ImportSSHPublicKey'
        },
        'Account.ImportMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportClientCertificate'
        }
      },
      Deleteable: true,
      RoleID: 'Administrator',
      Enabled: true,
      SnmpV3PrivProtocol: 'AES',
      InsecurePromptEnabled: false,
      ID: 2,
      UserName: 'Administrator',
      DelDisableReason: null
    },
    {
      LoginInterface: ['Web', 'SNMP', 'IPMI', 'SSH', 'Local', 'Redfish'],
      LoginRule: [],
      SnmpV3AuthProtocol: 'SHA',
      PasswordValidityDays: null,
      SSHPublicKeyHash: null,
      SNMPEncryptPwdInit: true,
      Actions: {
        'Account.DeleteSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/3/DeleteSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/3/DeleteSSHPublicKey'
        },
        'Account.DeleteMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteCertificate'
        },
        'Account.ImportSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/3/ImportSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/3/ImportSSHPublicKey'
        },
        'Account.ImportMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportClientCertificate'
        }
      },
      Deleteable: false,
      RoleID: 'Administrator',
      Enabled: true,
      SnmpV3PrivProtocol: 'AES',
      InsecurePromptEnabled: false,
      ID: 3,
      UserName: '10001',
      DelDisableReason: 'EmergencyUser'
    },
    {
      LoginInterface: ['Web', 'SNMP', 'IPMI', 'SSH', 'SFTP', 'Local', 'Redfish'],
      LoginRule: [],
      SnmpV3AuthProtocol: 'SHA',
      PasswordValidityDays: null,
      SSHPublicKeyHash: null,
      SNMPEncryptPwdInit: true,
      Actions: {
        'Account.DeleteSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/4/DeleteSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/4/DeleteSSHPublicKey'
        },
        'Account.DeleteMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteCertificate'
        },
        'Account.ImportSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/4/ImportSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/4/ImportSSHPublicKey'
        },
        'Account.ImportMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportClientCertificate'
        }
      },
      Deleteable: true,
      RoleID: 'CommonUser',
      Enabled: true,
      SnmpV3PrivProtocol: 'AES',
      InsecurePromptEnabled: true,
      ID: 4,
      UserName: 'zys001',
      DelDisableReason: null
    },
    {
      LoginInterface: ['Web', 'SNMP', 'IPMI', 'SSH', 'SFTP', 'Local', 'Redfish'],
      LoginRule: [],
      SnmpV3AuthProtocol: 'SHA',
      PasswordValidityDays: null,
      SSHPublicKeyHash: null,
      SNMPEncryptPwdInit: true,
      Actions: {
        'Account.DeleteSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/5/DeleteSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/5/DeleteSSHPublicKey'
        },
        'Account.DeleteMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteCertificate'
        },
        'Account.ImportSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/5/ImportSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/5/ImportSSHPublicKey'
        },
        'Account.ImportMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportClientCertificate'
        }
      },
      Deleteable: true,
      RoleID: 'CommonUser',
      Enabled: true,
      SnmpV3PrivProtocol: 'AES',
      InsecurePromptEnabled: false,
      ID: 5,
      UserName: 'zys002',
      DelDisableReason: null
    },
    {
      LoginInterface: ['Web', 'SNMP', 'SSH', 'SFTP', 'Local', 'Redfish'],
      LoginRule: [],
      SnmpV3AuthProtocol: 'SHA',
      PasswordValidityDays: null,
      SSHPublicKeyHash: null,
      SNMPEncryptPwdInit: true,
      Actions: {
        'Account.DeleteSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/6/DeleteSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/6/DeleteSSHPublicKey'
        },
        'Account.DeleteMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/DeleteCertificate'
        },
        'Account.ImportSSHPublicKey': {
          '@Redfish.ActionInfo': '/UI/Rest/AccessMgnt/Accounts/6/ImportSSHPublicKeyActionInfo',
          target: '/UI/Rest/AccessMgnt/Accounts/6/ImportSSHPublicKey'
        },
        'Account.ImportMutualAuthClientCert': {
          '@Redfish.ActionInfo':
            '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportMutualAuthClientCertActionInfo',
          target: '/UI/Rest/AccessMgnt/TwoFactorAuthentication/ImportClientCertificate'
        }
      },
      Deleteable: true,
      RoleID: 'CustomRole1',
      Enabled: true,
      SnmpV3PrivProtocol: 'AES',
      InsecurePromptEnabled: true,
      ID: 6,
      UserName: 'wuchanggui',
      DelDisableReason: null
    }
  ]
};
