//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MockMethod } from 'vite-plugin-mock';
import { cupJsonData, memoryJsonData, networkJsonData, diskJsonData, userData } from './data/index';
import { reqPath } from '../../../src/api/reqPath';

export default [
  {
    url: reqPath.monitor.cpu,
    method: 'get',
    timeout: 500,
    response: cupJsonData
  },
  {
    url: reqPath.monitor.memory,
    method: 'get',
    timeout: 500,
    response: memoryJsonData
  },
  {
    url: reqPath.monitor.network,
    method: 'get',
    timeout: 500,
    response: networkJsonData
  },
  {
    url: reqPath.monitor.hardDisk,
    method: 'get',
    timeout: 500,
    response: diskJsonData
  },
  {
    url: reqPath.user,
    method: 'get',
    timeout: 500,
    response: userData
  },
  {
    url: reqPath.monitor.setCpuThreshold,
    method: 'patch',
    timeout: 500,
    response: {
      code: 200
    }
  },
  {
    url: reqPath.monitor.clearHistory,
    method: 'post',
    timeout: 500,
    response: {
      code: 200
    }
  }
] as MockMethod[];
