//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MockMethod } from 'vite-plugin-mock';
import { reqPath } from '../../../../src/api/reqPath';
import pcieRiserCard from './data/pcieRiserCard';
import pciecard from './data/pciecard';
import diskBackplane from './data/diskBackplane';
import boards from './data/boards';

export default [
  {
    url: '/UI/Rest/System/Boards/PCIeCard',
    method: 'get',
    timeout: 500,
    response: pciecard
  },
  {
    url: '/UI/Rest/System/Boards/DiskBackplane',
    method: 'get',
    timeout: 500,
    response: diskBackplane
  },
  {
    url: '/UI/Rest/System/Boards/PCIeRiserCard',
    method: 'get',
    timeout: 500,
    response: pcieRiserCard
  },
  {
    url: reqPath.system.info.boards,
    method: 'get',
    timeout: 500,
    response: boards
  }
] as MockMethod[];
