//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export default [
  {
    PartNumber: null,
    Model: 'Hi1822',
    FirmwareVersion: null,
    PCIeFunctionDate: {
      LinkWidth: 'X8',
      SubsystemId: '0xd137',
      LinkSpeedAbility: 'N/A',
      SubsystemVendorId: '0x19e5',
      DeviceId: '0x0211',
      VendorId: '0x19e5',
      AssociatedResource: 'CPU1',
      LinkSpeed: 'N/A',
      LinkWidthAbility: 'X8'
    },
    Description: 'Hi1822 SP581 (4*25GE)',
    FunctionType: 'Net Card',
    ExtendInfo: { BoardId: '0x00f6', CPLDVersion: null, ProductName: 'SP581', PCBVersion: '.A' },
    Manufacturer: 'Huawei Technologies Co., Ltd.',
    Id: 'PCIeCard1',
    Position: 'PCIe Riser1',
    SerialNumber: null
  },
  {
    PartNumber: '03033DKM',
    FunctionType: 'SDI Card',
    PCIeFunctionDate: {
      LinkWidth: 'X16',
      SubsystemId: '0x0100',
      LinkSpeedAbility: 'N/A',
      SubsystemVendorId: '0x0200',
      DeviceId: '0xa125',
      VendorId: '0x19e5',
      AssociatedResource: 'CPU1',
      LinkSpeed: 'N/A',
      LinkWidthAbility: 'X16'
    },
    Description: 'SDI V3',
    ExtendInfo: {
      BoardId: '0x005e',
      M2Device1Presence: true,
      M2Device2Presence: true,
      ProductName: 'IT21SHSC',
      SDIPfMacInfo: [
        { PermanentMac: '00:02:03:04:05:06', Port: 1, PfId: 0 },
        { PermanentMac: '00:02:03:04:05:0a', Port: 1, PfId: 4 },
        { PermanentMac: '00:02:03:04:05:0c', Port: 1, PfId: 6 },
        { PermanentMac: '00:02:03:04:05:0e', Port: 1, PfId: 8 }
      ],
      StorageManagementIP: '0.0.0.0',
      ExtendCardInfo: [
        {
          BoardId: '0x00f6',
          Model: 'Hi1822',
          Slot: 1,
          SubsystemId: '0xd137',
          ProductName: 'SP581',
          BoardName: 'IT21ETHC',
          DeviceId: '0x0211',
          VendorId: '0x19e5',
          PfMacInfo: [
            { PermanentMac: '00:02:03:04:05:06', Port: 1, PfId: 0 },
            { PermanentMac: '00:02:03:04:05:0a', Port: 1, PfId: 4 },
            { PermanentMac: '00:02:03:04:05:0c', Port: 1, PfId: 6 },
            { PermanentMac: '00:02:03:04:05:0e', Port: 1, PfId: 8 },
            { PermanentMac: '00:02:03:04:05:14', Port: 1, PfId: 14 },
            { PermanentMac: '00:02:03:04:05:07', Port: 2, PfId: 1 },
            { PermanentMac: '00:02:03:04:05:0d', Port: 2, PfId: 7 },
            { PermanentMac: '00:02:03:04:05:0f', Port: 2, PfId: 9 },
            { PermanentMac: '00:02:03:04:05:08', Port: 3, PfId: 2 },
            { PermanentMac: '00:02:03:04:05:10', Port: 3, PfId: 10 },
            { PermanentMac: '00:02:03:04:05:09', Port: 4, PfId: 3 },
            { PermanentMac: '00:02:03:04:05:0b', Port: 4, PfId: 5 },
            { PermanentMac: '00:02:03:04:05:11', Port: 4, PfId: 11 },
            { PermanentMac: '00:02:03:04:05:12', Port: 4, PfId: 12 },
            { PermanentMac: '00:02:03:04:05:13', Port: 4, PfId: 13 }
          ],
          SubsystemVendorId: '0x19e5',
          ChipManufacturer: 'Huawei',
          Manufacturer: 'Huawei',
          PCBVersion: '.A',
          Description: '4*25GE'
        },
        {
          BoardId: '0x00da',
          Model: 'Hi1822',
          Slot: 3,
          SubsystemId: '0xd129',
          ProductName: 'SP570',
          BoardName: 'BC51ETHB',
          DeviceId: '0x1822',
          VendorId: '0x19e5',
          PfMacInfo: [
            { PermanentMac: 'a4:be:2b:3a:93:59', Port: 1, PfId: 0 },
            { PermanentMac: 'a4:be:2b:3a:93:5a', Port: 2, PfId: 1 },
            { PermanentMac: 'a4:be:2b:3a:93:5b', Port: 3, PfId: 2 },
            { PermanentMac: 'a4:be:2b:3a:93:5c', Port: 4, PfId: 3 }
          ],
          SubsystemVendorId: '0x19e5',
          ChipManufacturer: 'Huawei',
          Manufacturer: 'Huawei',
          PCBVersion: '.A',
          Description: '4*25GE'
        }
      ],
      StorageManagementVlanId: null,
      PCBVersion: '.A',
      BootOption: 'HDD Boot'
    },
    Position: 'PCIe Riser1',
    Manufacturer: 'Huawei Technologies Co., Ltd.',
    Id: 'PCIeCard2',
    SerialNumber: null
  }
];
