//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export default {
  RootCert: {
    Issuer: 'CN=zttt, OU=Huawei, O=IT, L=Hangzhou, S=ZheJiang, C=CN',
    ValidNotBefore: 'Aug 07 2020 UTC',
    ValidNotAfter: 'Aug 07 2040 UTC',
    Subject: 'CN=zttt, OU=Huawei, O=IT, L=Hangzhou, S=ZheJiang, C=CN',
    SerialNumber: '53 45 67 d4 94 68 00 f8'
  },
  ServerCert: {
    Issuer: 'CN=ztt2, OU=Huawei, O=IT, L=HZ, S=ZJ, C=CN',
    ValidNotBefore: 'Aug 07 2020 UTC',
    ValidNotAfter: 'Aug 07 2040 UTC',
    Subject: 'CN=ztt3, OU=HW, O=IT, L=HZ, S=ZJ, C=CN',
    SerialNumber: '06 57 8c ef b8 bc ef 00'
  },
  HTTPS: {
    Port: 443,
    Enabled: true
  },
  WebSession: {
    TimeoutMinutes: 464,
    Mode: 'Shared'
  },
  IntermediateCert: [
    {
      Issuer: 'CN=zttt, OU=Huawei, O=IT, L=Hangzhou, S=ZheJiang, C=CN',
      ValidNotBefore: 'Aug 07 2020 UTC',
      ValidNotAfter: 'Aug 07 2040 UTC',
      Subject: 'CN=ztt2, OU=Huawei, O=IT, L=HZ, S=ZJ, C=CN',
      SerialNumber: '5a a3 38 fc d2 85 5a 8d'
    }
  ],
  HTTP: {
    Port: 80,
    Enabled: true
  }
};